;;; batch-wblock-c3d-2025.lsp
;;; Batch WBLOCK pour Civil 3D 2025
;;; Ouvre chaque DWG du dossier source, fait un -WBLOCK All et exporte
;;; dans le dossier de destination avec le même nom.

(defun c:BatchWblock (/ src dest files acadObj docs fname f newDoc destFile)

  (vl-load-com)

  ;; Chemin source
  (setq src (getstring "\nDossier SOURCE (ex: C:\\Sources\\) : "))
  (if (not src) (progn (princ "\nAnnulé.") (exit)))

  ;; Chemin destination
  (setq dest (getstring "\nDossier DESTINATION (ex: C:\\WBLOCKS\\) : "))
  (if (not dest) (progn (princ "\nAnnulé.") (exit)))

  ;; S'assurer du slash final
  (defun fixp (p)
    (if (wcmatch (substr p (strlen p)) "[\\/]") p (strcat p "\\")))
  (setq src  (fixp src))
  (setq dest (fixp dest))

  ;; Liste DWG
  (setq files (vl-directory-files src "*.dwg" 1))
  (if (not files)
    (progn (princ "\nAucun DWG trouvé.") (exit))
  )

  (setq acadObj (vlax-get-acad-object))
  (setq docs (vla-get-Documents acadObj))

  (foreach f files
    (setq fname (vl-filename-base f))
    (setq f (strcat src f))
    (setq destFile (strcat dest fname ".dwg"))

    (princ (strcat "\nTraitement : " fname "..."))

    (setq newDoc
      (vl-catch-all-apply
        '(lambda ()
           ;; Ouvrir en lecture seule
           (vla-open docs f :vlax-true)
         )
      )
    )

    (if (vl-catch-all-error-p newDoc)
      (progn
        (princ (strcat "\nErreur ouverture : " f))
      )
      (progn
        ;; Récupérer l’objet doc réel
        (setq newDoc (vla-item docs (vla-get-count docs)))
        (vla-activate newDoc)

        ;; Pause courte — Civil 3D charge souvent des objets
        (vl-cmdf "._REGEN")
        (vl-cmdf "._QSAVE")   ;; évite certains crash Civil 3D
        (vl-cmdf "._UNDO" "_Control" "_None")

        ;; Exporte tout le contenu
        (vl-catch-all-apply
          '(lambda ()
             (command "-wBLOC" destFile "*" "_n")
           )
        )

        ;; Fermer le dessin sans sauver
        (vla-close newDoc :vlax-false)

        (princ "  OK")
      )
    )

  )

  (princ "\nTerminé.")
  (princ)
)
(princ "\nCommand BATCHWBLOCK (Civil 3D 2025) chargée.")
(princ)